## **1. Overview of Web Authentication**

- **Purpose**:
    
    - Provides network access for endpoints without an 802.1X supplicant or local credentials.
    - Commonly used for guest users, allowing them to:
        - Authenticate via a web portal.
        - Accept an Acceptable Use Policy (AUP).
        - Maintain an audit trail of network access.
- **Use Cases**:
    
    - Guest users with or without 802.1X supplicants.
    - Endpoints with misconfigured or nonfunctional 802.1X supplicants.

---

## **2. Web Authentication Scenarios**

Cisco ISE supports three main scenarios:

1. **Central Web Authentication (CWA)**:
    
    - Users are redirected to the Cisco ISE web portal for authentication.
    - Authentication is performed on Cisco ISE, followed by a CoA (Change of Authorization) request to the NAD for full network access.
2. **Local Web Authentication (LWA) on Cisco WLC**:
    
    - Users are redirected to the WLC for login.
    - The WLC prompts for credentials, authenticates via RADIUS, and redirects users back to their original destination.
3. **Local Web Authentication (LWA) on Wired NAD**:
    
    - Users are redirected to the switch's guest portal for login.
    - The switch authenticates the user via RADIUS pointing to Cisco ISE.

### **Advantages of CWA Over LWA**:

- **CWA** supports CoA, centralized audit logs, and a scalable configuration.
- **LWA** lacks CoA, requires per-device configuration, and has limited centralized logging.

---

## **3. Process of Central Web Authentication (CWA)**

### **Step-by-Step Flow**:

1. **Connection**:
    
    - The endpoint connects to the NAD (wired or wireless) with or without an 802.1X supplicant.
2. **Initial Request**:
    
    - If 802.1X times out, the NAD sends a MAB or access request to Cisco ISE.
3. **Authorization**:
    
    - Cisco ISE applies a restricted profile with URL redirection parameters.
4. **Redirect**:
    
    - The endpoint's HTTP/HTTPS request is redirected to the Cisco ISE Guest Portal.
5. **Authentication**:
    
    - The user enters credentials in the guest portal.
    - Cisco ISE authenticates the user against an identity store (e.g., Guest Users, Internal Users, or Active Directory).
6. **Access Update**:
    
    - After successful authentication, Cisco ISE sends a CoA to the NAD with a new authorization profile, enabling full network access.

---

## **4. CWA Configuration on Cisco Catalyst WLC**

### **Prerequisites**:

- RADIUS, AAA, and 802.1X configurations must be in place.

### **Steps to Configure CWA**:

1. **Configure AAA Authorization Method List**:
    
    - Navigate to **Configuration > Security > AAA > AAA Method List**.
    - Select **Authorization**, provide a name, and assign the appropriate server group.
2. **Create a Guest WLAN**:
    
    - Set **Layer 2 Security** to **None**.
    - Enable **MAC Filtering**.
    - Assign the AAA authentication and authorization method lists.
3. **Enable AAA Override and NAC State**:
    
    - Navigate to **Configuration > Tags & Profile > Policy**.
    - Edit the policy profile:
        - Enable **Allow AAA Override**.
        - Set **NAC State** to **RADIUS**.
        - Enable **AAA Accounting**.
4. **Configure Redirect ACL**:
    
    - Define traffic redirection behavior:
        - Permit web traffic (HTTP/HTTPS) to trigger redirection.
        - Deny DNS, DHCP, and traffic to the Cisco ISE portal (e.g., port 8443).
    - Example:
        
        ```none
        Deny: DNS, DHCP, ISE Portal  
        Permit: Web traffic (ports 80 and 443)  
        ```
        

---

## **5. CWA Configuration on Cisco ISE**

### **Steps to Configure CWA on ISE**:

1. **Verify Guest Portal**:
    
    - Use default portals (e.g., Sponsored Guest Portal) or create custom ones.
2. **Verify MAB Authentication Rule**:
    
    - Ensure the MAB rule allows unknown MAC addresses and applies the redirect URL and ACL.
3. **Create Authorization Profile for Redirection**:
    
    - Configure a profile for web redirection:
        - Set the redirect ACL name (e.g., ACL_WEBAUTH_REDIRECT).
        - Select the guest portal for redirection.
4. **Configure Authorization Rules**:
    
    - **CWA_Redirect Rule**:
        - Matches users connecting via MAB.
        - Applies the redirect profile to send the user to the guest portal.
    - **CWA_Authentication Rule**:
        - Matches users authenticated through the guest portal.
        - Removes redirection and applies full network access settings via CoA.

---

## **6. Key Notes**

- **Guest Portals**:
    
    - **Sponsored Guest Portal**: Sponsors create guest accounts with assigned credentials.
    - **Self-Registered Guest Portal**: Guests create their own accounts.
    - **Hotspot Guest Portal**: No authentication required, only AUP acceptance.
- **Authorization Rules**:
    
    - Avoid redirection loops by ensuring the **CWA_Authentication Rule** does not match the redirect profile again.
    - Add conditions for differentiated access (e.g., group-based permissions).
- **Redirect ACL Requirements**:
    
    - WLC actions:
        - **Permit** web traffic for redirection.
        - **Deny** DNS, DHCP, and ISE portal traffic.
    - ACL must describe traffic in both directions.

---

## **7. Advantages of CWA**

- Supports CoA for dynamic policy updates.
- Centralized authentication and audit logs.
- Flexible guest access configurations with AUP enforcement.

### **Disadvantages of LWA**:

- No CoA support.
- Requires per-device configuration.
- Limited centralized logging.

---

### **Conclusion**

Central Web Authentication (CWA) is a scalable and secure solution for guest network access. It provides centralized management, audit trails, and flexible policies for wired and wireless environments. By combining Cisco ISE’s robust identity services with the WLC’s redirection capabilities, CWA ensures a seamless and secure guest experience.